/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.message;

import com.github.L_Ender.cataclysm.Attachment.TidalTentacleAttachment;
import com.github.L_Ender.cataclysm.init.ModDataAttachments;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageTidalTentacle(int entityID, boolean tentacle) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageTidalTentacle> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"tentacle_attachment"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageTidalTentacle> STREAM_CODEC = CustomPacketPayload.codec(MessageTidalTentacle::write, MessageTidalTentacle::new);

    public MessageTidalTentacle(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID());
        buf.writeBoolean(this.tentacle());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(MessageTidalTentacle message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Level level = ctx.player().level();
            Entity entity = level.getEntity(message.entityID());
            if (entity instanceof Player) {
                Player player = (Player)entity;
                TidalTentacleAttachment attachment = (TidalTentacleAttachment)player.getData(ModDataAttachments.TIDAL_TENTACLE_ATTACHMENT);
                attachment.setHasTentacle(message.tentacle());
            }
        });
    }
}

